-- Quartus II VHDL Template
-- Binary Counter

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity test_risingEdge is

	port
	(
		clk		  	: in std_logic;
		reset			: in std_logic;
	

		x				: out std_logic;
		
		y				: in std_logic;
		
		state			: out std_logic_vector(1 downto 0);
	
		ok				: out std_logic
	);

end entity;

architecture rtl of test_risingEdge is
	signal   cnt: integer range 0 to 63;
	
	signal	x_out:std_logic:='0';
	signal	ok_next: std_logic:='1';
	signal	ok_out: std_logic:='1';

	
	signal my_state:std_logic_vector(1 downto 0):=(others=>'0');
	signal my_state_next:std_logic_vector(1 downto 0):=(others=>'0');
	
begin

	process (clk)
	variable cnt_next:integer range 0 to 100000;
	begin
	
	
	if (rising_edge(clk)) then
		if reset='1' then
			ok_out<='1';
			cnt<=0;
			cnt_next:=0;
			my_state<=(others=>'0');
		else
			cnt<=cnt_next;
			my_state<=my_state_next;
			ok_out<=ok_out and ok_next;
			--cnt_next:= cnt_next+1;
			cnt_next:=to_integer(unsigned(std_logic_vector(to_unsigned(cnt * 1103515245 + 12345, 17) and "11111111111111111")));
		end if;
	end if;
	end process;
	
	process (y,x_out,my_state) 
	begin
	
		my_state_next<= x_out & my_state(1);
			
		if y=(my_state(1)and not(my_state(0))) then
			ok_next<='1';
		else
			ok_next<='0';
		end if;
	
	end process;
	

	x<=std_logic_vector(to_unsigned(cnt, 6))(3);
	x_out<=std_logic_vector(to_unsigned(cnt, 6))(3);
	
	ok<=ok_out;
	state<=my_state;

end rtl;
